#include <stdio.h>

int hasConsecutiveDigits(int num) {
    int digit1, digit2;
    digit1 = num % 10;
    num /= 10;
    while (num > 0) {
        digit2 = num % 10;
        if (digit1 == digit2) {
            return 1;
        }
        digit1 = digit2;
        num /= 10;
    }
    return 0;
}

int hasSameDigitsThreeTimes(int num) {
    int count[10] = {0};
    while (num > 0) {
        count[num % 10]++;
        num /= 10;
    }
    for (int i = 0; i < 10; i++) {
        if (count[i] >= 3) {
            return 1;
        }
    }
    return 0;
}

int isAscendingOrDescending(int num) {
    int digit1, digit2;
    digit1 = num % 10;
    num /= 10;
    int ascending = 1, descending = 1;
    while (num > 0) {
        digit2 = num % 10;
        if (digit2 > digit1) {
            descending = 0;
        } else if (digit2 < digit1) {
            ascending = 0;
        }
        digit1 = digit2;
        num /= 10;
    }
    return ascending || descending;
}

int isAABBOrABAB(int num) {
    int digit1, digit2, digit3, digit4;
    digit1 = num % 10;
    num /= 10;
    digit2 = num % 10;
    num /= 10;
    digit3 = num % 10;
    num /= 10;
    digit4 = num % 10;
    if ((digit1 == digit2 && digit3 == digit4) || (digit1 == digit3 && digit2 == digit4)) {
        return 1;
    }
    return 0;
}

int calculatePrice(int num) {
    int price = 100;
    int temp = num;
    int count6 = 0, count8 = 0;
    while (temp > 0) {
        int digit = temp % 10;
        if (digit == 6) {
            count6++;
        } else if (digit == 8) {
            count8++;
        }
        temp /= 10;
    }
    price += 50 * (count6 + count8);

    if (isAscendingOrDescending(num)) {
        price *= 3;
    }

    if (hasSameDigitsThreeTimes(num)) {
        price *= 6;
    }

    if (isAABBOrABAB(num)) {
        price *= 2;
    }

    return price;
}

int main() {
    int num;
    scanf("%d", &num);
    int price = calculatePrice(num);
    printf("%d\n", price);
    return 0;
}
