#include <stdio.h>
#include <stdbool.h>

bool isUsed[9] = {false};
int count = 0;

bool isUnique(int num) {
    while (num > 0) {
        int digit = num % 10;
        if (digit == 0 || isUsed[digit - 1]) {
            return false;
        }
        isUsed[digit - 1] = true;
        num /= 10;
    }
    return true;
}

void resetUsed() {
    for (int i = 0; i < 9; i++) {
        isUsed[i] = false;
    }
}

void findFractionalRepresentations(int n) {
    for (int a = 1; a < n; a++) {
        for (int b = 1; b < 9876543; b++) {
            for (int c = 1; c < 9876543; c++) {
                int fraction = b / c;
                if (a + fraction == n && isUnique(a) && isUnique(b) && isUnique(c)) {
                    count++;
                }
                resetUsed();
            }
        }
    }
}

int main() {
    int n;
    scanf("%d", &n);
    findFractionalRepresentations(n);
    printf("%d\n", count);
    return 0;
}
