#include <stdio.h>
#include <stdlib.h>

typedef struct {
    int repairTime;
    int destroyTime;
} Board;

int compare(const void *a, const void *b) {
    Board *boardA = (Board *)a;
    Board *boardB = (Board *)b;
    return (boardA->destroyTime - boardA->repairTime) - (boardB->destroyTime - boardB->repairTime);
}

int rescueBoards(Board *boards, int n) {
    qsort(boards, n, sizeof(Board), compare);
    int time = 0;
    int count = 0;
    for (int i = 0; i < n; i++) {
        time += boards[i].repairTime;
        if (time <= boards[i].destroyTime) {
            count++;
        } else {
            break;
        }
    }
    return count;
}

int main() {
    int n;
    scanf("%d", &n);
    Board *boards = (Board *)malloc(n * sizeof(Board));
    for (int i = 0; i < n; i++) {
        scanf("%d %d", &boards[i].repairTime, &boards[i].destroyTime);
    }
    int count = rescueBoards(boards, n);
    printf("%d\n", count);
    free(boards);
    return 0;
}
